/** breakout game Main class - starts the game

listing of Javafx classes.
*/
import javafx.application.Application;
import javafx.stage.Stage;
import java.io.File;
import javafx.scene.media.*;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import java.io.File;

public class Main extends Application
{   
   
    /** The 'main' method - this is used when launching from the command line.*/
    public static void main( String args[] )
    {
       /**'launch' initialises the system and then calls 'start'
         (When running in BlueJ, the menu option 'Run JavaFX Application'
        calls 'start' itself)
        */
        launch(args);

        
       
    }
    
    
    
    /** the 'start' method - this creates the Model, View and Controller objects and
    // makes them talk to each other, it then sets up the user interface (in the View 
    // object) and starts the game running (in the Model object)
    */
    @Override
    public void start(Stage window) 
    {
         int H = 700;         /** Height of game window (in pixels)*/
         int W = 600;         /** Width  of game window (in pixels)*/

        
         /** set up debugging and print initial debugging message */
         Debug.set(true);    /** change this to 'false' to stop breakout printing messages */        
         Debug.trace("Main::start: Breakout starting"); 

         /** Create the Model, View and Controller objects */
         Model model = new Model(W,H);
         View  view  = new View(W,H);
         Controller controller  = new Controller();

         /** Link them together so they can talk to each other
         Each one has instance variables for the other two */
         model.view = view;
         model.controller = controller;

         controller.model = model;
         controller.view = view;

         view.model = model;
         view.controller = controller;

         
        
         /** Following code plays music upon start up
         
         this string locates the music file */
         String musicFile = "arcade.wav";    

         Media sound = new Media(new File(musicFile).toURI().toString());
         MediaPlayer mediaPlayer = new MediaPlayer(sound);/**mediaplayer locates the file */
         mediaPlayer.play();/**plays the audio.*/
         mediaPlayer.setAutoPlay(true);/**the next two lines of code loops the media.*/
         mediaPlayer.setCycleCount(MediaPlayer.INDEFINITE);
         
         /** start up the game interface (the View object, passing it the window
          object that JavaFX passed to this method, and then tell the model to 
          start the game */
         StackPane root = new StackPane();
         view.start(window); 				   
         model.startGame();

          /** application is now running - print a debug message to say so */
         Debug.trace("Main::start: Breakout running"); 
    }
 

}

